//
//  RVHardwareCommunicator.h
//  CommunicationModule
//
//  Created by Greg Harris on 7/23/12.
//  Copyright (c) 2012 Renewed Vision, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "RVProtocolParser.h"

extern NSString *RVHardwareInterfaceDisplayName;
extern NSString *RVHardwareInterfaceUniqueIdentifier;
extern NSString *RVHardwareInterfaceType;

typedef enum _RVHardwareCommunicatorType {
	RVHardwareCommunicatorTypeUnknown = 0,
	RVHardwareCommunicatorTypeSerial,
	RVHardwareCommunicatorTypeNetwork,
	RVHardwareCommunicatorTypeDMX, // hardware based DMX, not ArtNet
	RVHardwareCommunicatorTypeMIDI, // hardware based MIDI, not MIDI over LAN
} RVHardwareCommunicatorType;


@interface RVHardwareCommunicator : NSObject {
	NSString *_displayName;
	RVProtocolParser *parser;
	
	BOOL isActive;
}

@property (copy,nonatomic) NSString *displayName;
@property (assign) RVProtocolParser *parser;
@property (readonly) BOOL isActive;
@property (readonly) NSString *activeStateLabel;

- (RVHardwareCommunicatorType) communicatorType;
+ (NSArray *) availableInterfaces;
+ (NSArray *) availableInterfacesForType:(RVHardwareCommunicatorType)type;
+ (NSString *) hardwareTypeName;
+ (NSString *) setupViewNibName;

// each subclass will register itself which will allow us to loop through all subclasses
+ (void) registerSubclass:(Class)subclass;
+ (NSArray *) subclasses;

- (NSView *) setupView;

- (NSXMLElement *) serializedConnectionProperties;
- (id)initWithXML:(NSXMLElement *)element;

- (void) activate;
- (void) deactivate;

- (void) updateFromConfig;

@end
